<?php
// Iniciar sesión
session_start();
//consultamos el rol para dar acceso o no
require_once 'solicitudes/email_usuario_conectado.php';

// Verificar si el usuario es administrador
if ($result['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';

$error = '';
$success = '';

// Procesar la configuración
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $precio_ticket = $_POST['precio_ticket'];
    $validez_ticket = $_POST['validez_ticket'];
    $email_contacto = $_POST['email_contacto'];
    $empresa_nombre = $_POST['empresa_nombre'];
    $moneda = $_POST['moneda'];
    $numero_contacto = $_POST['numero_contacto'];
    $razon_social = $_POST['razon_social'];
    $direccion = $_POST['direccion'];

    // Validar los datos
    if (empty($precio_ticket) || empty($validez_ticket) || empty($email_contacto) || empty($empresa_nombre) || empty($moneda) || empty($numero_contacto) || empty($razon_social) || empty($direccion)) {
        $error = "Todos los campos son obligatorios.";
    } else {
        // Guardar los valores en la base de datos (puedes tener una tabla de configuración)
        $stmt = $pdo->prepare("UPDATE configuracion SET precio_ticket = :precio_ticket, validez_ticket = :validez_ticket, email_contacto = :email_contacto, empresa_nombre = :empresa_nombre, moneda = :moneda, numero_contacto = :numero_contacto, razon_social = :razon_social, direccion = :direccion WHERE id = 1");
        $stmt->execute([
            ':precio_ticket' => $precio_ticket,
            ':validez_ticket' => $validez_ticket,
            ':email_contacto' => $email_contacto,
            ':empresa_nombre' => $empresa_nombre,
            ':moneda' => $moneda,
            ':numero_contacto' => $numero_contacto,
            ':razon_social' => $razon_social,
            ':direccion' => $direccion
        ]);

        if ($stmt) {
            $success = "Configuración actualizada con éxito.";
        } else {
            $error = "Hubo un error al guardar la configuración.";
        }
    }
}

// Obtener la configuración actual (si existe)
$stmt = $pdo->query("SELECT * FROM configuracion WHERE id = 1");
$config = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Configuración - Sistema de Tickets</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

</head>
<body>
      <style>
    .mobile-buttons {
        display: none;
    }
    @media (max-width: 768px) {
        .mobile-buttons {
            display: flex;
            justify-content: space-around;
            margin-bottom: 15px;
        }
    }
  </style>
 <?php 
    include "menuajuste.php";
  ?>

  <!-- Contenido principal -->
  <div class="content">
    <h1 class="text-center mb-4">Configuración del Sistema de Tickets</h1>
    
    <?php if (!empty($error)) { echo "<div class='error'>$error</div>"; } ?>
    <?php if (!empty($success)) { echo "<div class='success'>$success</div>"; } ?>

    <!-- Configuración de la Empresa -->
    <div id="empresa" class="card">
        <div class="mobile-buttons">
    <a href="estadisticas.php" class="btn btn-primary">Estadísticas</a>
    <a href="gestion_tipos_tickets.php" class="btn btn-secondary">Tipos de Tickets</a>
    <a href="usuarios.php" class="btn btn-success">Usuarios</a>

  </div>
      <div id="empresa" class="card">
        <div class="mobile-buttons">
  <a href="logout.php" class="btn btn-success">Cerrar Sesion</a>
  
  </div>
      <div class="card-header">Configuración de la Empresa</div>
      <div class="card-body">
        <form action="configuracion.php" method="POST">
          <div class="mb-3">
            <label for="empresa_nombre" class="form-label">Nombre de la Empresa/Organización</label>
            <input type="text" class="form-control" id="empresa_nombre" name="empresa_nombre" value="<?= $config['empresa_nombre'] ?? '' ?>" required>
          </div>
          <div class="mb-3">
            <label for="razon_social" class="form-label">Razón Social</label>
            <input type="text" class="form-control" id="razon_social" name="razon_social" value="<?= $config['razon_social'] ?? '' ?>" required>
          </div>
          <div class="mb-3">
            <label for="direccion" class="form-label">Dirección del Establecimiento</label>
            <input type="text" class="form-control" id="direccion" name="direccion" value="<?= $config['direccion'] ?? '' ?>" required>
          </div>
      </div>
    </div>

    <!-- Correo Electrónico de Contacto -->
    <div id="contacto" class="card">
      <div class="card-header">Correo Electrónico de Contacto</div>
      <div class="card-body">
        <div class="mb-3">
          <label for="email_contacto" class="form-label">Correo Electrónico de Contacto</label>
          <input type="email" class="form-control" id="email_contacto" name="email_contacto" value="<?= $config['email_contacto'] ?? '' ?>" required>
        </div>
      </div>
    </div>

    <!-- Número de Contacto -->
    <div id="numero_contacto" class="card">
      <div class="card-header">Número de Contacto</div>
      <div class="card-body">
        <div class="mb-3">
          <label for="numero_contacto" class="form-label">Número de Contacto</label>
          <input type="text" class="form-control" id="numero_contacto" name="numero_contacto" value="<?= $config['numero_contacto'] ?? '' ?>" required>
        </div>
      </div>
    </div>

    <!-- Validez del Ticket -->
    <div id="validez" class="card">
      <div class="card-header">Validez del Ticket</div>
      <div class="card-body">
        <select class="form-select" id="validez_ticket" name="validez_ticket" required>
          <option value="1 hora" <?= (isset($config['validez_ticket']) && $config['validez_ticket'] == '1 hora') ? 'selected' : '' ?>>1 hora</option>
          <option value="2 horas" <?= (isset($config['validez_ticket']) && $config['validez_ticket'] == '2 horas') ? 'selected' : '' ?>>2 horas</option>
          <option value="3 horas" <?= (isset($config['validez_ticket']) && $config['validez_ticket'] == '3 horas') ? 'selected' : '' ?>>3 horas</option>
          <option value="4 horas" <?= (isset($config['validez_ticket']) && $config['validez_ticket'] == '4 horas') ? 'selected' : '' ?>>4 horas</option>
          <option value="Tiempo indefinido" <?= (isset($config['validez_ticket']) && $config['validez_ticket'] == 'Tiempo indefinido') ? 'selected' : '' ?>>Tiempo indefinido</option>
        </select>
      </div>
    </div>

    <!-- Precio del Ticket -->
    <div id="precio" class="card">
      <div class="card-header">Precio del Ticket</div>
      <div class="card-body">
        <div class="mb-3">
          <label for="precio_ticket" class="form-label">Precio del Ticket</label>
          <input type="text" class="form-control" id="precio_ticket" name="precio_ticket" value="<?= $config['precio_ticket'] ?? '' ?>" required>
        </div>
      </div>
    </div>

    <!-- Moneda -->
    <div id="moneda" class="card">
      <div class="card-header">Moneda</div>
      <div class="card-body">
        <select class="form-select" id="moneda" name="moneda" required>
          <option value="USD" <?= (isset($config['moneda']) && $config['moneda'] == 'USD') ? 'selected' : '' ?>>USD</option>
          <option value="EUR" <?= (isset($config['moneda']) && $config['moneda'] == 'EUR') ? 'selected' : '' ?>>EUR</option>
          <option value="MXN" <?= (isset($config['moneda']) && $config['moneda'] == 'MXN') ? 'selected' : '' ?>>MXN</option>
        </select>
      </div>
    </div>

    <div class="text-center">
      <button type="submit" class="btn btn-primary">Guardar Configuración</button>
    </form>
    <br><br><br>
    </div>
  </div>
</body>
</html>
